/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import libsidutils.IOUtils;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.WebJarsResourceRequestPathServletParameters;

@WebServlet(name="WebJarsServlet", displayName="WebJarsServlet", urlPatterns={"/webjars/*"}, description="Get web jars")
public class WebJarsServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            WebJarsServletParameters servletParameters = new WebJarsServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            try (InputStream source = servletParameters.getResource();){
                response.setHeader("Cache-Control", IServletSystemProperties.JSIDPlay2Server.CACHE_CONTROL_RESPONSE_HEADER_CACHED);
                ContentTypeAndFileExtensions mimeType = ContentTypeAndFileExtensions.getMimeType(IOUtils.getFilenameSuffix(request.getPathInfo()));
                this.setOutput(mimeType, response, source);
            }
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.WebJarsServletParameters")
    public static class WebJarsServletParameters
    extends WebJarsResourceRequestPathServletParameters {
    }
}

